#include "GameObject.h"

GameObject::GameObject()
{
	ID = 0;
	PlayerID = 0;
	x = 0;
	y = 0;
	
	font18 = al_load_font("arial.ttf", 18, 0);
	velX = 0;
	velY = 0;

	dirX = 0;
	dirY = 0;

	boundX = 0;
	boundY = 0;

	shipCount = 0;
	shipKiller = 0;

	maxFrame = 0;
	curFrame = 0;
	frameCount = 0;
	frameDelay = 0;
	frameWidth = 0;
	frameHeight = 0;
	animationColumns = 0;
	animationDirection = 0;

	image = NULL;
	BaseColor = al_map_rgb(255,255,255);

	alive = true;
	collidable = true;
}

void GameObject::Destroy()
{
	al_destroy_font(font18);
	al_destroy_bitmap(image);
}

void GameObject::Init(float x, float y, float velX, float velY, int dirX, int dirY, int boundX, int boundY)
{
	GameObject::x = x;
	GameObject::y = y;

	GameObject::velX = velX;
	GameObject::velY = velY;

	GameObject::dirX = dirX;
	GameObject::dirY = dirY;

	GameObject::boundX = boundX;
	GameObject::boundY = boundY;
}

void GameObject::Update()
{}

void GameObject::Render()
{}

bool GameObject::CheckCollisions(GameObject *otherObject)
{
	float oX = otherObject->GetX();
	float oY = otherObject->GetY();

	int obX = otherObject->GetBoundX();
	int obY = otherObject->GetBoundY();

	if( x + boundX > oX - obX &&
		x - boundX < oX + obX &&
		y + boundY > oY - obY &&
		y - boundY < oY + obY)
		return true;
	else
		return false;
}

void GameObject::Collided(int objectID, float velx, float vely)
{}

bool GameObject::Collidable()
{
	return alive && collidable;
}
